<?php
require_once('../general/db.php');
require_once('../general/response.php');

// attempt to set up connections to read and write db connections
try {
    $writeDB = DB::connectWriteDB();
    $readDB = DB::connectReadDB();
} catch (PDOException $ex) {
    //log the connection error
    error_log("Connection Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Database connection error");
    $response->send();
    exit;
}

try {
    if (!isset($_GET["url"])) {
        $response = new Response();
        $response->setHttpStatusCode(400);
        $response->setSuccess(false);
        (!isset($_GET["url"]) ? $response->addMessage("Url field is mandatory and must be provided") : false);
        $response->send();
        exit;
    }

    $url = $_GET["url"];

    // create db query
    $general_page_query = $readDB->prepare('SELECT * FROM general_page WHERE link = :url');
    $general_page_query->bindParam(":url", $url, PDO::PARAM_STR);
    $general_page_query->execute();

    // get row count
    $row_count = $general_page_query->rowCount();
    if ($row_count === 0) {
        $response = new Response();
        $response->setHttpStatusCode(404); //Not Found
        $response->setSuccess(false);
        $response->addMessage("General page not found");
        $response->send();
        exit();
    }
    $row = $general_page_query->fetch(PDO::FETCH_ASSOC);

    // create new object for each row
    $cover='https://digitalromania.ro/uploads/general_pages/'.$row['cover'];
    $general_page = array(
        'id'=> $row['id'],
        "title" => $row["title"],
        "description" => $row["description"],
        "cover" => $cover,
    );

    // set up response for successful return
    $response = new Response();
    $response->setHttpStatusCode(200);
    $response->setSuccess(true);
    $response->toCache(false);
    $response->setData($general_page);
    $response->send();
    exit;

} catch (PDOException $ex) {
    error_log("Database Query Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Failed to get general page" . $ex);
    $response->send();
    exit;
}
?>
