<?php
// BEGIN OF AUTH SCRIPT
if (!isset($_SERVER['HTTP_AUTHORIZATION']) || strlen($_SERVER['HTTP_AUTHORIZATION']) < 1) {
    $response = new Response();
    $response->setHttpStatusCode(401);
    $response->setSuccess(false);
    exit;
} else {
    $accesstoken = $_SERVER['HTTP_AUTHORIZATION'];
}
try {

    // create db query to check access token is equal to the one provided
    $query = $writeDB->prepare('SELECT id, valid_date FROM users WHERE token = :accesstoken');
    $query->bindParam(':accesstoken', $accesstoken, PDO::PARAM_STR);
    $query->execute();

    // get row count
    $rowCount = $query->rowCount();

    if ($rowCount === 0) {
        // set up response for unsuccessful log out response
        $response = new Response();
        $response->setHttpStatusCode(401);
        $response->setSuccess(false);
        $response->addMessage("Invalid access token");
        $response->send();
        exit;
    }
    $row = $query->fetch(PDO::FETCH_ASSOC);
    $valid_date = $row['valid_date'];
    $id = $row['id'];
    $date = date('Y-m-d h:m:s');

    if ($valid_date < $date) {
        $query = $writeDB->prepare('UPDATE users SET token = :token, valid_date = :valid_date WHERE id = :id');
        $query->bindParam(':id', $id, PDO::PARAM_INT);
        $query->bindParam(':token', $empty, PDO::PARAM_STR);
        $query->bindParam(':valid_date', $empty, PDO::PARAM_STR);
        $query->execute();
        // set up response for unsuccessful log out response
        $response = new Response();
        $response->setHttpStatusCode(403);
        $response->setSuccess(false);
        $response->addMessage("Token expired");
        $response->send();
        exit;
    }

} catch (PDOException $ex) {
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("There was an issue authenticating - please try again");
    $response->send();
    exit;
}