<?php
require_once('../general/db.php');
require_once('../general/response.php');

// attempt to set up connections to read and write db connections
try {
    $writeDB = DB::connectWriteDB();
    $readDB = DB::connectReadDB();
} catch (PDOException $ex) {
    //log the connection error
    error_log("Connection Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Database connection error");
    $response->send();
    exit;
}

try {
    // create db query
    $menu_query = $readDB->prepare('SELECT * FROM menu where parent_id=0 order by priority DESC');
    $menu_query->execute();

    // get row count
    $row_count = $menu_query->rowCount();
    $menu = array();

    $menu_items = array();
    while ($row = $menu_query->fetch(PDO::FETCH_ASSOC)) {
        $parent_id = $row['id'];
        $sum_menu_query = $readDB->prepare("SELECT * FROM menu WHERE parent_id = :parent_id");
        $sum_menu_query->bindParam("parent_id", $parent_id, PDO::PARAM_INT);
        $sum_menu_query->execute();

        $sub_menu_items = array();
        while($sub_menu_row = $sum_menu_query->fetch(PDO::FETCH_ASSOC)){
            $sub_menu_item = array(
              'name'=>  $sub_menu_row['name'],
              'link'=>  $sub_menu_row['link']
            );
            $sub_menu_items[] = $sub_menu_item;
        }
        $menu_item = array(
            'name'=>  $row['name'],
            'link'=>  $row['link'],
            'subMenuItems' => $sub_menu_items
        );

        // collect objects into an array
        $menu_items[] = $menu_item;
    }

    // set up response for successful return
    $response = new Response();
    $response->setHttpStatusCode(200);
    $response->setSuccess(true);
    $response->toCache(false);
    $response->setData($menu_items);
    $response->send();
    exit;

} catch (PDOException $ex) {
    error_log("Database Query Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Failed to get menu items" . $ex);
    $response->send();
    exit;
}
?>
