<?php
require_once('../general/db.php');
require_once('../general/response.php');

// attempt to set up connections to read and write db connections
try {
    $writeDB = DB::connectWriteDB();
    $readDB = DB::connectReadDB();
} catch (PDOException $ex) {
    //log the connection error
    error_log("Connection Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Database connection error");
    $response->send();
    exit;
}

try {
    if (!isset($_GET["url"])) {
        $response = new Response();
        $response->setHttpStatusCode(400);
        $response->setSuccess(false);
        (!isset($_GET["url"]) ? $response->addMessage("Url field is mandatory and must be provided") : false);
        $response->send();
        exit;
    }

    $url = $_GET["url"];

    // create db query
    $partner_query = $readDB->prepare('SELECT * FROM partners WHERE url = :url');
    $partner_query->bindParam(":url", $url, PDO::PARAM_STR);
    $partner_query->execute();

    // get row count
    $row_count = $partner_query->rowCount();
    if ($row_count === 0) {
        $response = new Response();
        $response->setHttpStatusCode(404); //Not Found
        $response->setSuccess(false);
        $response->addMessage("Partner not found");
        $response->send();
        exit();
    }
    $row = $partner_query->fetch(PDO::FETCH_ASSOC);

    // create new object for each row
    $image='https://digitalromania.ro/uploads/'.$row['post_image'];
    $partner = array(
        'id'=> $row['post_id'],
        "name" => $row["post_title"],
        "shortDesc" => $row["short_desc"],
        "image" => $image,
        "url" => $row["url"],
        "link" => $row["link"],
        'content' => $row['post_content'],
    );

    // set up response for successful return
    $response = new Response();
    $response->setHttpStatusCode(200);
    $response->setSuccess(true);
    $response->toCache(false);
    $response->setData($partner);
    $response->send();
    exit;

} catch (PDOException $ex) {
    error_log("Database Query Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Failed to get recent partner" . $ex);
    $response->send();
    exit;
}
?>
