<?php
require_once('../general/db.php');
require_once('../general/response.php');
// attempt to set up connections to read and write db connections
try {
    $writeDB = DB::connectWriteDB();
    $readDB = DB::connectReadDB();
} catch (PDOException $ex) {
    //log the connection error
    error_log("Connection Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Database connection error");
    $response->send();
    exit;
}

try {
    // create db query
    $podcasts_query = $readDB->prepare('SELECT * FROM podcasts');
    $podcasts_query->execute();

    // get row count
    $row_count = $podcasts_query->rowCount();

    if($row_count==0){
        $response = new Response();
        $response->setHttpStatusCode(404); //Not Found
        $response->setSuccess(false);
        $response->addMessage("Podcasts not found");
        $response->send();
        exit();
    }

    $podcasts = array();

    while ($row = $podcasts_query->fetch(PDO::FETCH_ASSOC)) {
        $podcast = array(
            "id" => $row["id"],
            "title" => $row["title"],
            "link" => $row["link"],
            "shortDesc" => $row["short_description"],
        );
        $podcasts[]=$podcast;
    }

    // set up response for successful return
    $response = new Response();
    $response->setHttpStatusCode(200);
    $response->setSuccess(true);
    $response->toCache(false);
    $response->setData($podcasts);
    $response->send();
    exit;

} catch (PDOException $ex) {
    error_log("Database Query Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Failed to get podcasts" . $ex);
    $response->send();
    exit;
}
?>
