<?php
require_once('../general/db.php');
require_once('../general/response.php');

// attempt to set up connections to read and write db connections
try {
    $writeDB = DB::connectWriteDB();
    $readDB = DB::connectReadDB();
} catch (PDOException $ex) {
    //log the connection error
    error_log("Connection Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Database connection error");
    $response->send();
    exit;
}

try {
    // create db query
    $report_query = $readDB->prepare('SELECT * FROM report ORDER BY id DESC');
    $report_query->execute();

    // get row count
    $row_count = $report_query->rowCount();
    $reports = array();

    while ($row = $report_query->fetch(PDO::FETCH_ASSOC)) {

        // create new object for each row
        $image='https://digitalromania.ro/uploads/'.$row['image'];
        $document='https://digitalromania.ro/uploads/'.$row['document'];
        $report = array(
            'name' => $row['name'],
            'image' => $image,
            'shortDescription' => $row['short_desc'],
            'document' => $document,
        );
        // collect objects into an array
        $reports[] = $report;
    }

    // set up response for successful return
    $response = new Response();
    $response->setHttpStatusCode(200);
    $response->setSuccess(true);
    $response->toCache(false);
    $response->setData($reports);
    $response->send();
    exit;

} catch (PDOException $ex) {
    error_log("Database Query Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Failed to get reports" . $ex);
    $response->send();
    exit;
}
?>
