<?php
require_once('../general/db.php');
require_once('../general/response.php');

// attempt to set up connections to read and write db connections
try {
    $writeDB = DB::connectWriteDB();
    $readDB = DB::connectReadDB();
} catch (PDOException $ex) {
    //log the connection error
    error_log("Connection Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Database connection error");
    $response->send();
    exit;
}

try {
    // create db query
    $testimonials_query = $readDB->prepare('SELECT * FROM testimonials ORDER BY priority');
    $testimonials_query->execute();

    // get row count
    $rowCount = $testimonials_query->rowCount();
    $testimonials = array();

    while ($row = $testimonials_query->fetch(PDO::FETCH_ASSOC)) {
        $testimonial = array(
            'name' => $row['name'],
            'company' => $row['company'],
            'text' => $row['text'],
        );
        // collect objects into an array
        $testimonials[] = $testimonial;
    }

    // set up response for successful return
    $response = new Response();
    $response->setHttpStatusCode(200);
    $response->setSuccess(true);
    $response->toCache(false);
    $response->setData($testimonials);
    $response->send();
    exit;

} catch (PDOException $ex) {
    error_log("Database Query Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Failed to get testimonials" . $ex);
    $response->send();
    exit;
}
?>
