<?php
require_once('../general/db.php');
require_once('../general/response.php');
// attempt to set up connections to read and write db connections
try {
    $writeDB = DB::connectWriteDB();
    $readDB = DB::connectReadDB();
} catch (PDOException $ex) {
    //log the connection error
    error_log("Connection Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Database connection error");
    $response->send();
    exit;
}

try {

    if (!isset($_GET["url"])) {
        $response = new Response();
        $response->setHttpStatusCode(400);
        $response->setSuccess(false);
        (!isset($_GET["url"]) ? $response->addMessage("Url field is mandatory and must be provided") : false);
        $response->send();
        exit;
    }

    $url = $_GET["url"];

    // create db query
    $post_sub_categories_query = $readDB->prepare('SELECT subs.* FROM subs INNER JOIN categories ON subs.cat_id = categories.cat_id WHERE categories.url = :url');
    $post_sub_categories_query->bindParam(":url", $url, PDO::PARAM_STR);
    $post_sub_categories_query->execute();

    // get row count
    $row_count = $post_sub_categories_query->rowCount();

    if($row_count==0){
        $response = new Response();
        $response->setHttpStatusCode(404); //Not Found
        $response->setSuccess(false);
        $response->addMessage("Sub categories not found");
        $response->send();
        exit();
    }

    $post_sub_categories = array();

    while ($row = $post_sub_categories_query->fetch(PDO::FETCH_ASSOC)) {
        $image='https://digitalromania.ro/uploads/'.$row['image'];
        $post_sub_category = array(
            "title" => $row["title"],
            "url" => $row["url"],
            "image" => $image,
        );
        $post_sub_categories[]=$post_sub_category;
    }

    // set up response for successful return
    $response = new Response();
    $response->setHttpStatusCode(200);
    $response->setSuccess(true);
    $response->toCache(false);
    $response->setData($post_sub_categories);
    $response->send();
    exit;

} catch (PDOException $ex) {
    error_log("Database Query Error: " . $ex, 0);
    $response = new Response();
    $response->setHttpStatusCode(500);
    $response->setSuccess(false);
    $response->addMessage("Failed to get sub categories" . $ex);
    $response->send();
    exit;
}
?>
